/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWAttachmentType {
    private static String undefined = "undefined";
    private static String library = "library";
    private static String folder = "folder";
    private static String document = "document";
    private static String storedSearch = "storedSearch";
    private static String url = "URL";
    private static String customObject = "customObject";
    private static final int MIN_ATTACHMENT_TYPE = 0;
    public static final int ATTACHMENT_TYPE_UNDEFINED = 0;
    public static final int ATTACHMENT_TYPE_LIBRARY = 1;
    public static final int ATTACHMENT_TYPE_FOLDER = 2;
    public static final int ATTACHMENT_TYPE_DOCUMENT = 3;
    public static final int ATTACHMENT_TYPE_STORED_SEARCH = 4;
    public static final int ATTACHMENT_TYPE_URL = 5;
    public static final int ATTACHMENT_TYPE_CUSTOM_OBJECT = 6;
    private static final int MAX_ATTACHMENT_TYPE = 6;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWAttachmentTypeUndefined", "Undefined").toString(), new VWString("VW.api.VWAttachmentTypeLibrary", "Library").toString(), new VWString("VW.api.VWAttachmentTypeFolder", "Folder").toString(), new VWString("VW.api.VWAttachmentTypeDocument", "Document").toString(), new VWString("VW.api.VWAttachmentTypeStoredSearch", "StoredSearch").toString(), new VWString("VW.api.VWAttachmentTypeURL", "URL").toString(), new VWString("VW.api.VWAttachmentTypeCustomObject", "CustomObject").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.20  $";
    }

    public static String getLocalizedString(int theAttachmentType) throws VWException {
        if (!VWAttachmentType.isValid(theAttachmentType)) {
            throw new VWException("vw.api.VWAttachmentTypeBadInteger", "Integer form of the Attachment type is invalid: {0}", String.valueOf(theAttachmentType));
        }
        return LocalizedStrings[theAttachmentType - 0];
    }

    public static boolean isValid(int theAttachmentType) {
        return theAttachmentType >= 0 && theAttachmentType <= 6;
    }

    protected static String typeToString(int theAttachmentType) throws VWException {
        switch (theAttachmentType) {
            case 0: {
                return undefined;
            }
            case 1: {
                return library;
            }
            case 2: {
                return folder;
            }
            case 3: {
                return document;
            }
            case 4: {
                return storedSearch;
            }
            case 5: {
                return url;
            }
            case 6: {
                return customObject;
            }
        }
        throw new VWException("vw.api.VWAttachmentTypeBadInteger", "Integer form of the Attachment type is invalid: {0}", String.valueOf(theAttachmentType));
    }

    protected static int stringToType(String theAttachmentType) throws VWException {
        if (theAttachmentType.equals(undefined)) {
            return 0;
        }
        if (theAttachmentType.equals(library)) {
            return 3;
        }
        if (theAttachmentType.equals(folder)) {
            return 2;
        }
        if (theAttachmentType.equals(document)) {
            return 3;
        }
        if (theAttachmentType.equals(storedSearch)) {
            return 4;
        }
        if (theAttachmentType.equals(url)) {
            return 5;
        }
        if (theAttachmentType.equals(customObject)) {
            return 6;
        }
        throw new VWException("vw.api.VWAttachmentTypeBadString", "The Attachment type is invalid: {0}", theAttachmentType);
    }
}

